function [residual, g1, g2, g3] = QuantMig_D92_DSGE_AutoMig_v12_19_Oct_21_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 153, 1);

%
% Model equations
%

T46 = params(74)^(1-params(109));
T51 = exp(y(37))^params(109);
T56 = params(89)^(1-params(109));
T60 = exp(y(38))^params(109);
T61 = T56*exp(y(29))/exp(y(36))*T60;
T66 = params(138)^(1-params(109));
T68 = exp(y(90))^params(109);
T73 = params(185)^(1-params(109));
T77 = exp(y(112))^params(109);
T117 = y(35)*exp(y(53))/exp(y(53));
T134 = params(93)*exp(y(50))^(-params(92));
T199 = params(124)*exp(y(103))^(-params(92));
T291 = params(94)*exp(y(66))^(-params(92));
T353 = params(116)*exp(y(82))^(-params(92));
T389 = params(198)^(1/params(206));
T396 = (1-params(198))^(1/params(206));
T402 = T389*exp(y(3))^params(209)+T396*(exp(y(122))*exp(y(120)))^params(209);
T411 = params(163)^(1/params(208));
T418 = (1-params(163))^(1/params(208));
T423 = T411*exp(y(2))^params(210)+T418*exp(y(4))^params(210);
T434 = params(164)^(1/params(207));
T439 = (1-params(164))^(1/params(207));
T442 = T434*exp(y(123))^params(211)+T439*exp(y(118))^params(211);
T445 = exp(y(28))*T442^(1/params(211));
T449 = 1/params(213);
T450 = params(161)^T449;
T458 = params(162)^T449;
T464 = T450*(exp(y(88))*exp(y(74)))^params(212)+T458*(exp(y(11))*exp(y(58)))^params(212);
T465 = 1/params(212);
T469 = params(160)^T449;
T476 = (1-params(160))^T449;
T482 = T469*(exp(y(6))*exp(y(42)))^params(212)+T476*(exp(y(109))*exp(y(95)))^params(212);
T493 = exp(y(28))*T396*T434*exp(y(15))*exp(y(122))^params(209);
T500 = T434*T402^(params(211)/params(209))+T439*T423^(params(211)/params(210));
T501 = 1/params(211)-1;
T502 = T500^T501;
T505 = T402^(params(211)/params(209)-1);
T508 = exp(y(120))^(params(209)-1);
T520 = T464^(params(209)/params(212)-1);
T523 = (exp(y(11))*exp(y(58)))^(params(212)-1);
T533 = (exp(y(88))*exp(y(74)))^(params(212)-1);
T544 = T423^(params(211)/params(210)-1);
T548 = T482^(params(210)/params(212)-1);
T550 = (exp(y(6))*exp(y(42)))^(params(212)-1);
T560 = (exp(y(109))*exp(y(95)))^(params(212)-1);
T583 = params(231)*exp(y(116))^params(230)+(1-params(231))*exp(y(115))^params(230);
T584 = 1/params(230);
T595 = params(231)*exp(y(117))^params(230)+(1-params(231))*exp(y(114))^params(230);
T658 = y(35)*exp(y(106))/exp(y(106));
T671 = T442^T501;
T676 = T583^(params(210)/params(230)-1);
T679 = exp(y(116))^(params(230)-1);
T686 = exp(y(115))^(params(230)-1);
T712 = exp(y(52))-exp(y(8))*(1+params(22))+(1-params(101))*params(105)/exp(y(48));
T722 = exp(y(68))-exp(y(9))*(1+params(22))+(1-params(102))*params(106)/exp(y(64));
T732 = exp(y(84))-exp(y(86))*(1+params(22))+(1-params(111))*params(113)/exp(y(80));
T742 = exp(y(105))-exp(y(107))*(1+params(22))+(1-params(119))*params(121)/exp(y(101));
T753 = params(107)/(exp(y(53))*(1-params(20)));
T766 = params(108)/((1-params(20))*exp(y(69)));
T779 = params(114)/((1-params(20))*exp(y(85)));
T792 = params(122)/((1-params(20))*exp(y(106)));
T826 = params(221)*exp(y(15))^(-params(4));
T850 = exp(y(17))+exp(y(121))+exp(y(5))+exp(y(16))+exp(y(24))+params(105)*exp(y(46))+params(121)*exp(y(99))+params(106)*exp(y(62))+params(113)*exp(y(78));
T853 = exp(y(14))/exp(y(15));
T859 = params(222)*T853^params(216)*exp(y(30));
T880 = exp(y(14))*y(13)*exp(y(128))/exp(y(128))/exp(y(14));
T1145 = params(99)*exp(y(46))^params(103);
T1147 = exp(y(41))^(1-params(103));
T1152 = params(110)*exp(y(78))^params(103);
T1153 = exp(y(73))^(1-params(103));
T1158 = params(100)*exp(y(62))^params(103);
T1159 = exp(y(57))^(1-params(103));
T1164 = params(118)*exp(y(99))^params(103);
T1165 = exp(y(94))^(1-params(103));
T1244 = exp(y(74))+exp(y(95))+exp(y(58))+exp(y(42));
lhs =y(29);
rhs =y(29)*params(5)+params(151)*x(2);
residual(1)= lhs-rhs;
lhs =y(110);
rhs =params(5)*y(110)+params(151)*x(8);
residual(2)= lhs-rhs;
lhs =y(36);
rhs =y(110)*params(185)+y(29)*params(89);
residual(3)= lhs-rhs;
lhs =y(35);
rhs =y(35)*params(15)+(1-params(15))*params(2)+params(153)*x(4);
residual(4)= lhs-rhs;
lhs =exp(y(37));
rhs =T46*params(239)/exp(y(36))*T51;
residual(5)= lhs-rhs;
lhs =exp(y(38));
rhs =T61;
residual(6)= lhs-rhs;
lhs =exp(y(90));
rhs =params(239)/exp(y(36))*T66*T68;
residual(7)= lhs-rhs;
lhs =exp(y(112));
rhs =T73*exp(y(110))/exp(y(36))*T77;
residual(8)= lhs-rhs;
lhs =(exp(y(7))-exp(y(7))*params(13))^(-params(228));
rhs =exp(y(53))*(1+params(21));
residual(9)= lhs-rhs;
lhs =params(226)*(exp(y(6))-exp(y(6))*params(57))^params(11);
rhs =exp(y(53))*exp(y(8))*exp(y(44))*(1-params(20));
residual(10)= lhs-rhs;
lhs =1/(1+y(13));
rhs =T117*exp(y(14))/exp(y(14));
residual(11)= lhs-rhs;
lhs =exp(y(51))*exp(y(47));
rhs =T134-exp(y(53))*params(76);
residual(12)= lhs-rhs;
lhs =exp(y(51));
rhs =(-params(226))/(1+params(11))*exp(y(6))^(1+params(11))+y(35)*((1-params(20))*exp(y(6))*exp(y(53))*exp(y(8))+exp(y(51))*(1-params(101))-T134);
residual(13)= lhs-rhs;
lhs =(1+params(21))*exp(y(106));
rhs =(exp(y(108))-params(13)*exp(y(108)))^(-params(228));
residual(14)= lhs-rhs;
lhs =params(224)*(exp(y(109))-params(57)*exp(y(109)))^params(11);
rhs =(1-params(20))*exp(y(106))*exp(y(107))*exp(y(97));
residual(15)= lhs-rhs;
lhs =exp(y(14))*exp(y(106))*(1+params(10)*(y(126)-params(214)));
rhs =(1+y(13))*exp(y(14))*y(35)*exp(y(106));
residual(16)= lhs-rhs;
lhs =exp(y(104))*exp(y(100));
rhs =T199-exp(y(106))*params(125);
residual(17)= lhs-rhs;
lhs =exp(y(104));
rhs =(-params(224))/(1+params(11))*exp(y(109))^(1+params(11))+y(35)*((1-params(20))*exp(y(109))*exp(y(106))*exp(y(107))+exp(y(104))*(1-params(119))-T199);
residual(18)= lhs-rhs;
lhs =(1+params(21))*exp(y(108))+exp(y(114));
rhs =(1-params(20))*exp(y(97))*exp(y(109))*exp(y(107))+exp(y(17))+params(125)*exp(y(96))+exp(y(125))*exp(y(115))+exp(y(14))*(1+y(13))*y(126)/exp(y(110))-exp(y(14))*y(126);
residual(19)= lhs-rhs;
lhs =(1+params(21))*exp(y(69));
rhs =(exp(y(10))-params(13)*exp(y(10)))^(-params(229));
residual(20)= lhs-rhs;
lhs =params(225)*(exp(y(11))-params(57)*exp(y(11)))^params(11);
rhs =(1-params(20))*exp(y(69))*exp(y(9))*exp(y(60));
residual(21)= lhs-rhs;
lhs =(1+params(21))*exp(y(10));
rhs =exp(y(17))+exp(y(60))*exp(y(11))*(1-params(20))*exp(y(9))+params(91)*exp(y(59));
residual(22)= lhs-rhs;
lhs =exp(y(67))*exp(y(63));
rhs =T291-exp(y(69))*params(91);
residual(23)= lhs-rhs;
lhs =exp(y(67));
rhs =(-params(225))/(1+params(11))*exp(y(11))^(1+params(11))+y(35)*((1-params(20))*exp(y(11))*exp(y(69))*exp(y(9))+exp(y(67))*(1-params(102))-T291);
residual(24)= lhs-rhs;
lhs =(1+params(21))*exp(y(85));
rhs =(exp(y(87))-params(13)*exp(y(87)))^(-params(229));
residual(25)= lhs-rhs;
lhs =params(227)*(exp(y(88))-params(57)*exp(y(88)))^params(11);
rhs =(1-params(20))*exp(y(85))*exp(y(86))*exp(y(76));
residual(26)= lhs-rhs;
lhs =(1+params(21))*exp(y(87));
rhs =exp(y(17))+exp(y(76))*exp(y(88))*(1-params(20))*exp(y(86))+params(140)*exp(y(75));
residual(27)= lhs-rhs;
lhs =exp(y(83))*exp(y(79));
rhs =T353-exp(y(85))*params(140);
residual(28)= lhs-rhs;
lhs =exp(y(83));
rhs =(-params(227))/(1+params(11))*exp(y(88))^(1+params(11))+y(35)*((1-params(20))*exp(y(88))*exp(y(85))*exp(y(86))+exp(y(83))*(1-params(111))-T353);
residual(29)= lhs-rhs;
lhs =exp(y(122));
rhs =exp(y(122))*params(237)+(1-params(237))*params(200)+params(238)*x(10);
residual(30)= lhs-rhs;
lhs =exp(y(123));
rhs =T402^(1/params(209));
residual(31)= lhs-rhs;
lhs =exp(y(118));
rhs =T423^(1/params(210));
residual(32)= lhs-rhs;
lhs =exp(y(1));
rhs =T445;
residual(33)= lhs-rhs;
lhs =exp(y(3));
rhs =T464^T465;
residual(34)= lhs-rhs;
lhs =exp(y(4));
rhs =T482^T465;
residual(35)= lhs-rhs;
lhs =exp(y(119));
rhs =T493*T502*T505*T508;
residual(36)= lhs-rhs;
lhs =exp(y(68));
rhs =T505*T502*exp(y(28))*T458*T389*T434*exp(y(15))*T520*T523;
residual(37)= lhs-rhs;
lhs =exp(y(84));
rhs =T520*T505*T502*exp(y(28))*T450*T389*T434*exp(y(15))*T533;
residual(38)= lhs-rhs;
lhs =exp(y(52));
rhs =T502*exp(y(28))*T469*T418*T439*exp(y(15))*T544*T548*T550;
residual(39)= lhs-rhs;
lhs =exp(y(105));
rhs =T548*T544*T502*exp(y(28))*T476*T418*T439*exp(y(15))*T560;
residual(40)= lhs-rhs;
lhs =exp(y(28));
rhs =exp(y(28))*params(3)+(1-params(3))*params(166)+params(150)*x(1);
residual(41)= lhs-rhs;
lhs =exp(y(2));
rhs =T583^T584;
residual(42)= lhs-rhs;
lhs =exp(y(5));
rhs =T595^T584;
residual(43)= lhs-rhs;
lhs =y(130);
rhs =exp(y(117))*params(235)*exp(y(31));
residual(44)= lhs-rhs;
lhs =y(131);
rhs =y(130)/exp(y(117));
residual(45)= lhs-rhs;
residual(46) = y(132);
lhs =y(134);
rhs =exp(y(31))*exp(y(114))*params(235);
residual(47)= lhs-rhs;
lhs =y(135);
rhs =y(134)/exp(y(114));
residual(48)= lhs-rhs;
residual(49) = y(136);
lhs =y(138);
rhs =params(235)*exp(y(121))*exp(y(34));
residual(50)= lhs-rhs;
lhs =y(139);
rhs =y(138)/exp(y(121));
residual(51)= lhs-rhs;
residual(52) = y(140);
lhs =exp(y(116));
rhs =y(130)+exp(y(116))*(1-params(7));
residual(53)= lhs-rhs;
lhs =exp(y(115));
rhs =y(134)+exp(y(115))*(1-params(7));
residual(54)= lhs-rhs;
lhs =exp(y(133));
rhs =T117*(exp(y(124))+(1-params(7))*exp(y(133)));
residual(55)= lhs-rhs;
lhs =1;
rhs =y(131)*exp(y(133))+y(35)*y(132)*exp(y(133));
residual(56)= lhs-rhs;
lhs =exp(y(137));
rhs =T658*(exp(y(125))+(1-params(7))*exp(y(137)));
residual(57)= lhs-rhs;
lhs =1;
rhs =y(135)*exp(y(137))+y(35)*y(136)*exp(y(137));
residual(58)= lhs-rhs;
lhs =exp(y(124));
rhs =T544*params(231)*exp(y(28))*T411*T439*T671*T676*T679;
residual(59)= lhs-rhs;
lhs =exp(y(125));
rhs =T676*T544*T671*(1-params(231))*exp(y(28))*T411*T439*T686;
residual(60)= lhs-rhs;
lhs =y(31);
rhs =y(31)*params(16)+params(155)*x(5);
residual(61)= lhs-rhs;
lhs =y(34);
rhs =y(34)*params(234)+params(233)*x(9);
residual(62)= lhs-rhs;
lhs =params(105)/exp(y(48));
rhs =T117*T712;
residual(63)= lhs-rhs;
lhs =params(106)/exp(y(64));
rhs =T117*T722;
residual(64)= lhs-rhs;
lhs =params(113)/exp(y(80));
rhs =T117*T732;
residual(65)= lhs-rhs;
lhs =params(121)/exp(y(101));
rhs =T117*T742;
residual(66)= lhs-rhs;
lhs =exp(y(8));
rhs =(1-params(107))/(1+params(22))*(exp(y(52))+(1-params(101))*params(105)/exp(y(48)))+T753*(T134-exp(y(51))*(1-params(101)));
residual(67)= lhs-rhs;
lhs =exp(y(9));
rhs =(1-params(108))/(1+params(22))*(exp(y(68))+(1-params(102))*params(106)/exp(y(64)))+T766*(T291-exp(y(67))*(1-params(102)));
residual(68)= lhs-rhs;
lhs =exp(y(86));
rhs =(1-params(114))/(1+params(22))*(exp(y(84))+(1-params(111))*params(113)/exp(y(80)))+T779*(T353-exp(y(83))*(1-params(111)));
residual(69)= lhs-rhs;
lhs =exp(y(107));
rhs =(1-params(122))/(1+params(22))*(exp(y(105))+(1-params(119))*params(121)/exp(y(101)))+T792*(T199-exp(y(104))*(1-params(119)));
residual(70)= lhs-rhs;
lhs =exp(y(120));
rhs =y(138)+exp(y(120))*(1-params(199))/exp(y(36));
residual(71)= lhs-rhs;
lhs =exp(y(141));
rhs =T117*(exp(y(119))+(1-params(199))*exp(y(141)));
residual(72)= lhs-rhs;
lhs =1;
rhs =y(139)*exp(y(141))+y(35)*y(140)*exp(y(141));
residual(73)= lhs-rhs;
lhs =params(221)*exp(y(15))^(1-params(4));
rhs =1-(1-params(221))*exp(y(14))^(1-params(4));
residual(74)= lhs-rhs;
lhs =exp(y(1));
rhs =T826*T850+T859;
residual(75)= lhs-rhs;
lhs =y(30);
rhs =y(30)*params(6)+x(3);
residual(76)= lhs-rhs;
lhs =y(13);
rhs =params(217)*exp((-params(10))*(y(12)-params(214)));
residual(77)= lhs-rhs;
lhs =y(12);
rhs =y(12)*T880+y(129);
residual(78)= lhs-rhs;
lhs =y(129);
rhs =1-T850/exp(y(128));
residual(79)= lhs-rhs;
lhs =exp(y(128));
rhs =exp(y(1))*exp(y(15));
residual(80)= lhs-rhs;
lhs =exp(y(16));
rhs =exp(y(37))*exp(y(7))+exp(y(38))*exp(y(10))+exp(y(112))*exp(y(108))+exp(y(90))*exp(y(87));
residual(81)= lhs-rhs;
lhs =y(12);
rhs =exp(y(37))*y(127)+exp(y(112))*y(126);
residual(82)= lhs-rhs;
lhs =exp(y(17));
rhs =exp(y(17))*params(1)+(1-params(1))*params(40)-params(50)*(exp(y(1))-params(26))-params(49)*(y(18)-params(218))+y(32);
residual(83)= lhs-rhs;
lhs =y(32);
rhs =y(32)*params(18)+params(158)*x(6);
residual(84)= lhs-rhs;
lhs =exp(y(24));
rhs =exp(y(24))*params(51)+(1-params(51))*params(39)-(exp(y(1))-params(26))*params(53)-params(52)*(y(18)-params(214))+y(33);
residual(85)= lhs-rhs;
lhs =y(33);
rhs =y(33)*params(19)+params(156)*x(7);
residual(86)= lhs-rhs;
lhs =exp(y(19));
rhs =params(20)*exp(y(44))*exp(y(6))*exp(y(8));
residual(87)= lhs-rhs;
lhs =exp(y(111));
rhs =params(20)*exp(y(97))*exp(y(109))*exp(y(107));
residual(88)= lhs-rhs;
lhs =exp(y(89));
rhs =params(20)*exp(y(76))*exp(y(88))*exp(y(86));
residual(89)= lhs-rhs;
lhs =exp(y(20));
rhs =params(20)*exp(y(60))*exp(y(11))*exp(y(9));
residual(90)= lhs-rhs;
lhs =exp(y(21));
rhs =exp(y(37))*exp(y(19))+exp(y(112))*exp(y(111))+exp(y(38))*exp(y(20))+exp(y(90))*exp(y(89));
residual(91)= lhs-rhs;
lhs =exp(y(22));
rhs =params(21)*exp(y(16));
residual(92)= lhs-rhs;
lhs =exp(y(23));
rhs =params(22)*(exp(y(42))*exp(y(6))*exp(y(8))+exp(y(109))*exp(y(107))*exp(y(95))+exp(y(74))*exp(y(88))*exp(y(86))+exp(y(58))*exp(y(11))*exp(y(9)));
residual(93)= lhs-rhs;
lhs =exp(y(25));
rhs =exp(y(23))+exp(y(21))+exp(y(22));
residual(94)= lhs-rhs;
lhs =y(27);
rhs =(1+y(13))*y(18)/exp(y(36))-y(18);
residual(95)= lhs-rhs;
lhs =exp(y(26));
rhs =exp(y(17))+exp(y(24));
residual(96)= lhs-rhs;
lhs =y(27);
rhs =exp(y(25))-(exp(y(26))+params(76)*exp(y(41))+params(91)*exp(y(57))+params(140)*exp(y(73))+params(125)*exp(y(94)));
residual(97)= lhs-rhs;
lhs =exp(y(39));
rhs =(exp(y(42))+exp(y(41)))/exp(y(37));
residual(98)= lhs-rhs;
lhs =exp(y(71));
rhs =(exp(y(74))+exp(y(73)))/exp(y(90));
residual(99)= lhs-rhs;
lhs =exp(y(92));
rhs =(exp(y(95))+exp(y(94)))/exp(y(112));
residual(100)= lhs-rhs;
lhs =exp(y(55));
rhs =(exp(y(58))+exp(y(57)))/exp(y(38));
residual(101)= lhs-rhs;
lhs =exp(y(40));
rhs =exp(y(41))/(exp(y(42))+exp(y(41)));
residual(102)= lhs-rhs;
lhs =exp(y(72));
rhs =exp(y(73))/(exp(y(74))+exp(y(73)));
residual(103)= lhs-rhs;
lhs =exp(y(93));
rhs =exp(y(94))/(exp(y(95))+exp(y(94)));
residual(104)= lhs-rhs;
lhs =exp(y(56));
rhs =exp(y(57))/(exp(y(58))+exp(y(57)));
residual(105)= lhs-rhs;
lhs =exp(y(42));
rhs =(1-params(101))*exp(y(42))+exp(y(45))+exp(y(39))*y(36)*params(74)*(1-exp(y(40)));
residual(106)= lhs-rhs;
lhs =exp(y(74));
rhs =(1-params(111))*exp(y(74))+exp(y(77))+exp(y(71))*y(36)*params(138)*(1-exp(y(72)));
residual(107)= lhs-rhs;
lhs =exp(y(58));
rhs =(1-params(102))*exp(y(58))+exp(y(61))+exp(y(55))*y(36)*params(89)*(1-exp(y(56)));
residual(108)= lhs-rhs;
lhs =exp(y(95));
rhs =(1-params(119))*exp(y(95))+exp(y(98))+exp(y(92))*y(36)*params(185)*(1-exp(y(93)));
residual(109)= lhs-rhs;
lhs =exp(y(42));
rhs =exp(y(37))*exp(y(44));
residual(110)= lhs-rhs;
lhs =exp(y(74));
rhs =exp(y(90))*exp(y(76));
residual(111)= lhs-rhs;
lhs =exp(y(58));
rhs =exp(y(38))*exp(y(60));
residual(112)= lhs-rhs;
lhs =exp(y(95));
rhs =exp(y(112))*exp(y(97));
residual(113)= lhs-rhs;
lhs =exp(y(41));
rhs =exp(y(37))*exp(y(43))+y(36)*exp(y(40))*params(74)*exp(y(39));
residual(114)= lhs-rhs;
lhs =exp(y(73));
rhs =exp(y(90))*exp(y(75))+y(36)*exp(y(72))*params(138)*exp(y(71));
residual(115)= lhs-rhs;
lhs =exp(y(94));
rhs =exp(y(112))*exp(y(96))+y(36)*exp(y(93))*params(185)*exp(y(92));
residual(116)= lhs-rhs;
lhs =exp(y(57));
rhs =exp(y(38))*exp(y(59))+y(36)*exp(y(56))*params(89)*exp(y(55));
residual(117)= lhs-rhs;
lhs =exp(y(45));
rhs =T1145*T1147;
residual(118)= lhs-rhs;
lhs =exp(y(77));
rhs =T1152*T1153;
residual(119)= lhs-rhs;
lhs =exp(y(61));
rhs =T1158*T1159;
residual(120)= lhs-rhs;
lhs =exp(y(98));
rhs =T1164*T1165;
residual(121)= lhs-rhs;
lhs =exp(y(47));
rhs =exp(y(45))/exp(y(41));
residual(122)= lhs-rhs;
lhs =exp(y(63));
rhs =exp(y(61))/exp(y(57));
residual(123)= lhs-rhs;
lhs =exp(y(79));
rhs =exp(y(77))/exp(y(73));
residual(124)= lhs-rhs;
lhs =exp(y(100));
rhs =exp(y(98))/exp(y(94));
residual(125)= lhs-rhs;
lhs =exp(y(48));
rhs =exp(y(45))/exp(y(46));
residual(126)= lhs-rhs;
lhs =exp(y(64));
rhs =exp(y(61))/exp(y(62));
residual(127)= lhs-rhs;
lhs =exp(y(80));
rhs =exp(y(77))/exp(y(78));
residual(128)= lhs-rhs;
lhs =exp(y(101));
rhs =exp(y(98))/exp(y(99));
residual(129)= lhs-rhs;
lhs =exp(y(49));
rhs =exp(y(46))/exp(y(41));
residual(130)= lhs-rhs;
lhs =exp(y(65));
rhs =exp(y(62))/exp(y(57));
residual(131)= lhs-rhs;
lhs =exp(y(81));
rhs =exp(y(78))/exp(y(73));
residual(132)= lhs-rhs;
lhs =exp(y(102));
rhs =exp(y(99))/exp(y(94));
residual(133)= lhs-rhs;
lhs =1;
rhs =exp(y(50))+exp(y(44))+exp(y(43));
residual(134)= lhs-rhs;
lhs =1;
rhs =exp(y(66))+exp(y(60))+exp(y(59));
residual(135)= lhs-rhs;
lhs =1;
rhs =exp(y(82))+exp(y(76))+exp(y(75));
residual(136)= lhs-rhs;
lhs =1;
rhs =exp(y(103))+exp(y(97))+exp(y(96));
residual(137)= lhs-rhs;
lhs =exp(y(54));
rhs =exp(y(6))*exp(y(42));
residual(138)= lhs-rhs;
lhs =exp(y(70));
rhs =exp(y(11))*exp(y(58));
residual(139)= lhs-rhs;
lhs =exp(y(91));
rhs =exp(y(88))*exp(y(74));
residual(140)= lhs-rhs;
lhs =exp(y(113));
rhs =exp(y(109))*exp(y(95));
residual(141)= lhs-rhs;
lhs =exp(y(142));
rhs =exp(y(8))/exp(y(86));
residual(142)= lhs-rhs;
lhs =exp(y(143));
rhs =exp(y(8))/exp(y(107));
residual(143)= lhs-rhs;
lhs =exp(y(144));
rhs =exp(y(86))/exp(y(9));
residual(144)= lhs-rhs;
lhs =exp(y(145));
rhs =exp(y(107))/exp(y(9));
residual(145)= lhs-rhs;
lhs =exp(y(146));
rhs =exp(y(42))/T1244;
residual(146)= lhs-rhs;
lhs =exp(y(147));
rhs =exp(y(74))/T1244;
residual(147)= lhs-rhs;
lhs =exp(y(148));
rhs =exp(y(58))/T1244;
residual(148)= lhs-rhs;
lhs =exp(y(149));
rhs =exp(y(95))/T1244;
residual(149)= lhs-rhs;
lhs =exp(y(150));
rhs =exp(y(44))*exp(y(6))*exp(y(8));
residual(150)= lhs-rhs;
lhs =exp(y(151));
rhs =exp(y(76))*exp(y(88))*exp(y(86));
residual(151)= lhs-rhs;
lhs =exp(y(152));
rhs =exp(y(60))*exp(y(11))*exp(y(9));
residual(152)= lhs-rhs;
lhs =exp(y(153));
rhs =exp(y(97))*exp(y(109))*exp(y(107));
residual(153)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(153, 153);

  %
  % Jacobian matrix
  %

T1278 = T411*exp(y(2))*getPowerDeriv(exp(y(2)),params(210),1);
T1279 = getPowerDeriv(T423,1/params(210),1);
T1282 = getPowerDeriv(T423,params(211)/params(210),1);
T1285 = getPowerDeriv(T500,T501,1);
T1302 = getPowerDeriv(T423,params(211)/params(210)-1,1);
T1327 = T389*exp(y(3))*getPowerDeriv(exp(y(3)),params(209),1);
T1328 = getPowerDeriv(T402,1/params(209),1);
T1331 = getPowerDeriv(T402,params(211)/params(209),1);
T1336 = getPowerDeriv(T402,params(211)/params(209)-1,1);
T1369 = T418*exp(y(4))*getPowerDeriv(exp(y(4)),params(210),1);
T1427 = T469*exp(y(6))*exp(y(42))*getPowerDeriv(exp(y(6))*exp(y(42)),params(212),1);
T1428 = getPowerDeriv(T482,T465,1);
T1430 = (-(T1427*T1428));
T1431 = getPowerDeriv(T482,params(210)/params(212)-1,1);
T1439 = (-(T550*T502*exp(y(28))*T469*T418*T439*exp(y(15))*T544*T1427*T1431+T502*exp(y(28))*T469*T418*T439*exp(y(15))*T544*T548*exp(y(6))*exp(y(42))*getPowerDeriv(exp(y(6))*exp(y(42)),params(212)-1,1)));
T1492 = T458*exp(y(11))*exp(y(58))*getPowerDeriv(exp(y(11))*exp(y(58)),params(212),1);
T1493 = getPowerDeriv(T464,T465,1);
T1495 = (-(T1492*T1493));
T1496 = getPowerDeriv(T464,params(209)/params(212)-1,1);
T1504 = (-(T523*T505*T502*exp(y(28))*T458*T389*T434*exp(y(15))*T1492*T1496+T505*T502*exp(y(28))*T458*T389*T434*exp(y(15))*T520*exp(y(11))*exp(y(58))*getPowerDeriv(exp(y(11))*exp(y(58)),params(212)-1,1)));
T1530 = getPowerDeriv(T853,params(216),1);
T1768 = params(93)*exp(y(50))*getPowerDeriv(exp(y(50)),(-params(92)),1);
T1769 = (-T1768);
T1875 = params(94)*exp(y(66))*getPowerDeriv(exp(y(66)),(-params(92)),1);
T1876 = (-T1875);
T1926 = T450*exp(y(88))*exp(y(74))*getPowerDeriv(exp(y(88))*exp(y(74)),params(212),1);
T1928 = (-(T1493*T1926));
T1939 = (-(T533*T505*T502*exp(y(28))*T450*T389*T434*exp(y(15))*T1496*T1926+T520*T505*T502*exp(y(28))*T450*T389*T434*exp(y(15))*exp(y(88))*exp(y(74))*getPowerDeriv(exp(y(88))*exp(y(74)),params(212)-1,1)));
T2000 = params(116)*exp(y(82))*getPowerDeriv(exp(y(82)),(-params(92)),1);
T2001 = (-T2000);
T2084 = T476*exp(y(109))*exp(y(95))*getPowerDeriv(exp(y(109))*exp(y(95)),params(212),1);
T2086 = (-(T1428*T2084));
T2097 = (-(T560*T544*T502*exp(y(28))*T476*T418*T439*exp(y(15))*T1431*T2084+T548*T544*T502*exp(y(28))*T476*T418*T439*exp(y(15))*exp(y(109))*exp(y(95))*getPowerDeriv(exp(y(109))*exp(y(95)),params(212)-1,1)));
T2154 = params(124)*exp(y(103))*getPowerDeriv(exp(y(103)),(-params(92)),1);
T2155 = (-T2154);
T2223 = getPowerDeriv(T595,T584,1);
T2234 = (1-params(231))*exp(y(115))*getPowerDeriv(exp(y(115)),params(230),1);
T2235 = getPowerDeriv(T583,T584,1);
T2239 = getPowerDeriv(T583,params(210)/params(230)-1,1);
T2253 = params(231)*exp(y(116))*getPowerDeriv(exp(y(116)),params(230),1);
T2280 = T439*exp(y(118))*getPowerDeriv(exp(y(118)),params(211),1);
T2281 = getPowerDeriv(T442,1/params(211),1);
T2285 = getPowerDeriv(T442,T501,1);
T2301 = T396*exp(y(122))*exp(y(120))*getPowerDeriv(exp(y(122))*exp(y(120)),params(209),1);
T2303 = (-(T1328*T2301));
T2324 = (-(T523*T520*(T502*exp(y(28))*T458*T389*T434*exp(y(15))*T1336*T2301+T505*exp(y(28))*T458*T389*T434*exp(y(15))*T1285*T434*T1331*T2301)));
T2331 = (-(T533*T520*(T502*exp(y(28))*T450*T389*T434*exp(y(15))*T1336*T2301+T505*exp(y(28))*T450*T389*T434*exp(y(15))*T1285*T434*T1331*T2301)));
T2365 = T434*exp(y(123))*getPowerDeriv(exp(y(123)),params(211),1);
  g1(1,29)=1-params(5);
  g1(2,110)=1-params(5);
  g1(3,29)=(-params(89));
  g1(3,36)=1;
  g1(3,110)=(-params(185));
  g1(4,35)=1-params(15);
  g1(5,36)=(-(T51*T46*(-(params(239)*exp(y(36))))/(exp(y(36))*exp(y(36)))));
  g1(5,37)=exp(y(37))-T46*params(239)/exp(y(36))*exp(y(37))*getPowerDeriv(exp(y(37)),params(109),1);
  g1(6,29)=(-T61);
  g1(6,36)=(-(T60*T56*(-(exp(y(36))*exp(y(29))))/(exp(y(36))*exp(y(36)))));
  g1(6,38)=exp(y(38))-T56*exp(y(29))/exp(y(36))*exp(y(38))*getPowerDeriv(exp(y(38)),params(109),1);
  g1(7,36)=(-(T68*T66*(-(params(239)*exp(y(36))))/(exp(y(36))*exp(y(36)))));
  g1(7,90)=exp(y(90))-params(239)/exp(y(36))*T66*exp(y(90))*getPowerDeriv(exp(y(90)),params(109),1);
  g1(8,36)=(-(T77*T73*(-(exp(y(36))*exp(y(110))))/(exp(y(36))*exp(y(36)))));
  g1(8,110)=(-(T73*exp(y(110))/exp(y(36))*T77));
  g1(8,112)=exp(y(112))-T73*exp(y(110))/exp(y(36))*exp(y(112))*getPowerDeriv(exp(y(112)),params(109),1);
  g1(9,7)=(exp(y(7))-exp(y(7))*params(13))*getPowerDeriv(exp(y(7))-exp(y(7))*params(13),(-params(228)),1);
  g1(9,53)=(-(exp(y(53))*(1+params(21))));
  g1(10,6)=params(226)*(exp(y(6))-exp(y(6))*params(57))*getPowerDeriv(exp(y(6))-exp(y(6))*params(57),params(11),1);
  g1(10,8)=(-(exp(y(53))*exp(y(8))*exp(y(44))*(1-params(20))));
  g1(10,44)=(-(exp(y(53))*exp(y(8))*exp(y(44))*(1-params(20))));
  g1(10,53)=(-(exp(y(53))*exp(y(8))*exp(y(44))*(1-params(20))));
  g1(11,13)=(-1)/((1+y(13))*(1+y(13)));
  g1(11,35)=(-1);
  g1(12,47)=exp(y(51))*exp(y(47));
  g1(12,50)=T1769;
  g1(12,51)=exp(y(51))*exp(y(47));
  g1(12,53)=exp(y(53))*params(76);
  g1(13,6)=(-((-params(226))/(1+params(11))*exp(y(6))*getPowerDeriv(exp(y(6)),1+params(11),1)+y(35)*(1-params(20))*exp(y(6))*exp(y(53))*exp(y(8))));
  g1(13,8)=(-(y(35)*(1-params(20))*exp(y(6))*exp(y(53))*exp(y(8))));
  g1(13,35)=(-((1-params(20))*exp(y(6))*exp(y(53))*exp(y(8))+exp(y(51))*(1-params(101))-T134));
  g1(13,50)=(-(y(35)*T1769));
  g1(13,51)=exp(y(51))-y(35)*exp(y(51))*(1-params(101));
  g1(13,53)=(-(y(35)*(1-params(20))*exp(y(6))*exp(y(53))*exp(y(8))));
  g1(14,106)=(1+params(21))*exp(y(106));
  g1(14,108)=(-((exp(y(108))-params(13)*exp(y(108)))*getPowerDeriv(exp(y(108))-params(13)*exp(y(108)),(-params(228)),1)));
  g1(15,97)=(-((1-params(20))*exp(y(106))*exp(y(107))*exp(y(97))));
  g1(15,106)=(-((1-params(20))*exp(y(106))*exp(y(107))*exp(y(97))));
  g1(15,107)=(-((1-params(20))*exp(y(106))*exp(y(107))*exp(y(97))));
  g1(15,109)=params(224)*(exp(y(109))-params(57)*exp(y(109)))*getPowerDeriv(exp(y(109))-params(57)*exp(y(109)),params(11),1);
  g1(16,13)=(-(exp(y(14))*y(35)*exp(y(106))));
  g1(16,14)=exp(y(14))*exp(y(106))*(1+params(10)*(y(126)-params(214)))-(1+y(13))*exp(y(14))*y(35)*exp(y(106));
  g1(16,35)=(-((1+y(13))*exp(y(14))*exp(y(106))));
  g1(16,106)=exp(y(14))*exp(y(106))*(1+params(10)*(y(126)-params(214)))-(1+y(13))*exp(y(14))*y(35)*exp(y(106));
  g1(16,126)=exp(y(14))*exp(y(106))*params(10);
  g1(17,100)=exp(y(104))*exp(y(100));
  g1(17,103)=T2155;
  g1(17,104)=exp(y(104))*exp(y(100));
  g1(17,106)=exp(y(106))*params(125);
  g1(18,35)=(-((1-params(20))*exp(y(109))*exp(y(106))*exp(y(107))+exp(y(104))*(1-params(119))-T199));
  g1(18,103)=(-(y(35)*T2155));
  g1(18,104)=exp(y(104))-y(35)*exp(y(104))*(1-params(119));
  g1(18,106)=(-(y(35)*(1-params(20))*exp(y(109))*exp(y(106))*exp(y(107))));
  g1(18,107)=(-(y(35)*(1-params(20))*exp(y(109))*exp(y(106))*exp(y(107))));
  g1(18,109)=(-(y(35)*(1-params(20))*exp(y(109))*exp(y(106))*exp(y(107))+(-params(224))/(1+params(11))*exp(y(109))*getPowerDeriv(exp(y(109)),1+params(11),1)));
  g1(19,13)=(-(exp(y(14))*y(126)/exp(y(110))));
  g1(19,14)=(-(exp(y(14))*(1+y(13))*y(126)/exp(y(110))-exp(y(14))*y(126)));
  g1(19,17)=(-exp(y(17)));
  g1(19,96)=(-(params(125)*exp(y(96))));
  g1(19,97)=(-((1-params(20))*exp(y(97))*exp(y(109))*exp(y(107))));
  g1(19,107)=(-((1-params(20))*exp(y(97))*exp(y(109))*exp(y(107))));
  g1(19,108)=(1+params(21))*exp(y(108));
  g1(19,109)=(-((1-params(20))*exp(y(97))*exp(y(109))*exp(y(107))));
  g1(19,110)=(-((-(exp(y(110))*exp(y(14))*(1+y(13))*y(126)))/(exp(y(110))*exp(y(110)))));
  g1(19,114)=exp(y(114));
  g1(19,115)=(-(exp(y(125))*exp(y(115))));
  g1(19,125)=(-(exp(y(125))*exp(y(115))));
  g1(19,126)=(-((1+y(13))*exp(y(14))/exp(y(110))-exp(y(14))));
  g1(20,10)=(-((exp(y(10))-params(13)*exp(y(10)))*getPowerDeriv(exp(y(10))-params(13)*exp(y(10)),(-params(229)),1)));
  g1(20,69)=(1+params(21))*exp(y(69));
  g1(21,9)=(-((1-params(20))*exp(y(69))*exp(y(9))*exp(y(60))));
  g1(21,11)=params(225)*(exp(y(11))-params(57)*exp(y(11)))*getPowerDeriv(exp(y(11))-params(57)*exp(y(11)),params(11),1);
  g1(21,60)=(-((1-params(20))*exp(y(69))*exp(y(9))*exp(y(60))));
  g1(21,69)=(-((1-params(20))*exp(y(69))*exp(y(9))*exp(y(60))));
  g1(22,9)=(-(exp(y(60))*exp(y(11))*(1-params(20))*exp(y(9))));
  g1(22,10)=(1+params(21))*exp(y(10));
  g1(22,11)=(-(exp(y(60))*exp(y(11))*(1-params(20))*exp(y(9))));
  g1(22,17)=(-exp(y(17)));
  g1(22,59)=(-(params(91)*exp(y(59))));
  g1(22,60)=(-(exp(y(60))*exp(y(11))*(1-params(20))*exp(y(9))));
  g1(23,63)=exp(y(67))*exp(y(63));
  g1(23,66)=T1876;
  g1(23,67)=exp(y(67))*exp(y(63));
  g1(23,69)=exp(y(69))*params(91);
  g1(24,9)=(-(y(35)*(1-params(20))*exp(y(11))*exp(y(69))*exp(y(9))));
  g1(24,11)=(-(y(35)*(1-params(20))*exp(y(11))*exp(y(69))*exp(y(9))+(-params(225))/(1+params(11))*exp(y(11))*getPowerDeriv(exp(y(11)),1+params(11),1)));
  g1(24,35)=(-((1-params(20))*exp(y(11))*exp(y(69))*exp(y(9))+exp(y(67))*(1-params(102))-T291));
  g1(24,66)=(-(y(35)*T1876));
  g1(24,67)=exp(y(67))-y(35)*exp(y(67))*(1-params(102));
  g1(24,69)=(-(y(35)*(1-params(20))*exp(y(11))*exp(y(69))*exp(y(9))));
  g1(25,85)=(1+params(21))*exp(y(85));
  g1(25,87)=(-((exp(y(87))-params(13)*exp(y(87)))*getPowerDeriv(exp(y(87))-params(13)*exp(y(87)),(-params(229)),1)));
  g1(26,76)=(-((1-params(20))*exp(y(85))*exp(y(86))*exp(y(76))));
  g1(26,85)=(-((1-params(20))*exp(y(85))*exp(y(86))*exp(y(76))));
  g1(26,86)=(-((1-params(20))*exp(y(85))*exp(y(86))*exp(y(76))));
  g1(26,88)=params(227)*(exp(y(88))-params(57)*exp(y(88)))*getPowerDeriv(exp(y(88))-params(57)*exp(y(88)),params(11),1);
  g1(27,17)=(-exp(y(17)));
  g1(27,75)=(-(params(140)*exp(y(75))));
  g1(27,76)=(-(exp(y(76))*exp(y(88))*(1-params(20))*exp(y(86))));
  g1(27,86)=(-(exp(y(76))*exp(y(88))*(1-params(20))*exp(y(86))));
  g1(27,87)=(1+params(21))*exp(y(87));
  g1(27,88)=(-(exp(y(76))*exp(y(88))*(1-params(20))*exp(y(86))));
  g1(28,79)=exp(y(83))*exp(y(79));
  g1(28,82)=T2001;
  g1(28,83)=exp(y(83))*exp(y(79));
  g1(28,85)=exp(y(85))*params(140);
  g1(29,35)=(-((1-params(20))*exp(y(88))*exp(y(85))*exp(y(86))+exp(y(83))*(1-params(111))-T353));
  g1(29,82)=(-(y(35)*T2001));
  g1(29,83)=exp(y(83))-y(35)*exp(y(83))*(1-params(111));
  g1(29,85)=(-(y(35)*(1-params(20))*exp(y(88))*exp(y(85))*exp(y(86))));
  g1(29,86)=(-(y(35)*(1-params(20))*exp(y(88))*exp(y(85))*exp(y(86))));
  g1(29,88)=(-(y(35)*(1-params(20))*exp(y(88))*exp(y(85))*exp(y(86))+(-params(227))/(1+params(11))*exp(y(88))*getPowerDeriv(exp(y(88)),1+params(11),1)));
  g1(30,122)=exp(y(122))-exp(y(122))*params(237);
  g1(31,3)=(-(T1327*T1328));
  g1(31,120)=T2303;
  g1(31,122)=T2303;
  g1(31,123)=exp(y(123));
  g1(32,2)=(-(T1278*T1279));
  g1(32,4)=(-(T1279*T1369));
  g1(32,118)=exp(y(118));
  g1(33,1)=exp(y(1));
  g1(33,28)=(-T445);
  g1(33,118)=(-(exp(y(28))*T2280*T2281));
  g1(33,123)=(-(exp(y(28))*T2281*T2365));
  g1(34,3)=exp(y(3));
  g1(34,11)=T1495;
  g1(34,58)=T1495;
  g1(34,74)=T1928;
  g1(34,88)=T1928;
  g1(35,4)=exp(y(4));
  g1(35,6)=T1430;
  g1(35,42)=T1430;
  g1(35,95)=T2086;
  g1(35,109)=T2086;
  g1(36,2)=(-(T508*T505*T493*T439*T1278*T1282*T1285));
  g1(36,3)=(-(T508*(T505*T493*T1285*T434*T1327*T1331+T493*T502*T1327*T1336)));
  g1(36,4)=(-(T508*T505*T493*T1285*T439*T1282*T1369));
  g1(36,15)=(-(T493*T502*T505*T508));
  g1(36,28)=(-(T493*T502*T505*T508));
  g1(36,119)=exp(y(119));
  g1(36,120)=(-(T508*(T505*T493*T1285*T434*T1331*T2301+T493*T502*T1336*T2301)+T493*T502*T505*exp(y(120))*getPowerDeriv(exp(y(120)),params(209)-1,1)));
  g1(36,122)=(-(T508*(T493*T502*T1336*T2301+T505*(T493*T1285*T434*T1331*T2301+T502*exp(y(28))*T396*T434*exp(y(15))*exp(y(122))*getPowerDeriv(exp(y(122)),params(209),1)))));
  g1(37,2)=(-(T523*T520*T505*exp(y(28))*T458*T389*T434*exp(y(15))*T439*T1278*T1282*T1285));
  g1(37,3)=(-(T523*T520*(T502*exp(y(28))*T458*T389*T434*exp(y(15))*T1327*T1336+T505*exp(y(28))*T458*T389*T434*exp(y(15))*T1285*T434*T1327*T1331)));
  g1(37,4)=(-(T523*T520*T505*exp(y(28))*T458*T389*T434*exp(y(15))*T1285*T439*T1282*T1369));
  g1(37,11)=T1504;
  g1(37,15)=(-(T505*T502*exp(y(28))*T458*T389*T434*exp(y(15))*T520*T523));
  g1(37,28)=(-(T505*T502*exp(y(28))*T458*T389*T434*exp(y(15))*T520*T523));
  g1(37,58)=T1504;
  g1(37,68)=exp(y(68));
  g1(37,74)=(-(T523*T505*T502*exp(y(28))*T458*T389*T434*exp(y(15))*T1496*T1926));
  g1(37,88)=(-(T523*T505*T502*exp(y(28))*T458*T389*T434*exp(y(15))*T1496*T1926));
  g1(37,120)=T2324;
  g1(37,122)=T2324;
  g1(38,2)=(-(T533*T520*T505*exp(y(28))*T450*T389*T434*exp(y(15))*T439*T1278*T1282*T1285));
  g1(38,3)=(-(T533*T520*(T502*exp(y(28))*T450*T389*T434*exp(y(15))*T1327*T1336+T505*exp(y(28))*T450*T389*T434*exp(y(15))*T1285*T434*T1327*T1331)));
  g1(38,4)=(-(T533*T520*T505*exp(y(28))*T450*T389*T434*exp(y(15))*T1285*T439*T1282*T1369));
  g1(38,11)=(-(T533*T505*T502*exp(y(28))*T450*T389*T434*exp(y(15))*T1492*T1496));
  g1(38,15)=(-(T520*T505*T502*exp(y(28))*T450*T389*T434*exp(y(15))*T533));
  g1(38,28)=(-(T520*T505*T502*exp(y(28))*T450*T389*T434*exp(y(15))*T533));
  g1(38,58)=(-(T533*T505*T502*exp(y(28))*T450*T389*T434*exp(y(15))*T1492*T1496));
  g1(38,74)=T1939;
  g1(38,84)=exp(y(84));
  g1(38,88)=T1939;
  g1(38,120)=T2331;
  g1(38,122)=T2331;
  g1(39,2)=(-(T550*T548*(T544*exp(y(28))*T469*T418*T439*exp(y(15))*T439*T1278*T1282*T1285+T502*exp(y(28))*T469*T418*T439*exp(y(15))*T1278*T1302)));
  g1(39,3)=(-(T550*T548*T544*exp(y(28))*T469*T418*T439*exp(y(15))*T1285*T434*T1327*T1331));
  g1(39,4)=(-(T550*T548*(T544*exp(y(28))*T469*T418*T439*exp(y(15))*T1285*T439*T1282*T1369+T502*exp(y(28))*T469*T418*T439*exp(y(15))*T1302*T1369)));
  g1(39,6)=T1439;
  g1(39,15)=(-(T502*exp(y(28))*T469*T418*T439*exp(y(15))*T544*T548*T550));
  g1(39,28)=(-(T502*exp(y(28))*T469*T418*T439*exp(y(15))*T544*T548*T550));
  g1(39,42)=T1439;
  g1(39,52)=exp(y(52));
  g1(39,95)=(-(T550*T502*exp(y(28))*T469*T418*T439*exp(y(15))*T544*T1431*T2084));
  g1(39,109)=(-(T550*T502*exp(y(28))*T469*T418*T439*exp(y(15))*T544*T1431*T2084));
  g1(39,120)=(-(T550*T548*T544*exp(y(28))*T469*T418*T439*exp(y(15))*T1285*T434*T1331*T2301));
  g1(39,122)=(-(T550*T548*T544*exp(y(28))*T469*T418*T439*exp(y(15))*T1285*T434*T1331*T2301));
  g1(40,2)=(-(T560*T548*(T502*exp(y(28))*T476*T418*T439*exp(y(15))*T1278*T1302+T544*exp(y(28))*T476*T418*T439*exp(y(15))*T439*T1278*T1282*T1285)));
  g1(40,3)=(-(T560*T548*T544*exp(y(28))*T476*T418*T439*exp(y(15))*T1285*T434*T1327*T1331));
  g1(40,4)=(-(T560*T548*(T502*exp(y(28))*T476*T418*T439*exp(y(15))*T1302*T1369+T544*exp(y(28))*T476*T418*T439*exp(y(15))*T1285*T439*T1282*T1369)));
  g1(40,6)=(-(T560*T544*T502*exp(y(28))*T476*T418*T439*exp(y(15))*T1427*T1431));
  g1(40,15)=(-(T548*T544*T502*exp(y(28))*T476*T418*T439*exp(y(15))*T560));
  g1(40,28)=(-(T548*T544*T502*exp(y(28))*T476*T418*T439*exp(y(15))*T560));
  g1(40,42)=(-(T560*T544*T502*exp(y(28))*T476*T418*T439*exp(y(15))*T1427*T1431));
  g1(40,95)=T2097;
  g1(40,105)=exp(y(105));
  g1(40,109)=T2097;
  g1(40,120)=(-(T560*T548*T544*exp(y(28))*T476*T418*T439*exp(y(15))*T1285*T434*T1331*T2301));
  g1(40,122)=(-(T560*T548*T544*exp(y(28))*T476*T418*T439*exp(y(15))*T1285*T434*T1331*T2301));
  g1(41,28)=exp(y(28))-exp(y(28))*params(3);
  g1(42,2)=exp(y(2));
  g1(42,115)=(-(T2234*T2235));
  g1(42,116)=(-(T2235*T2253));
  g1(43,5)=exp(y(5));
  g1(43,114)=(-((1-params(231))*exp(y(114))*getPowerDeriv(exp(y(114)),params(230),1)*T2223));
  g1(43,117)=(-(T2223*params(231)*exp(y(117))*getPowerDeriv(exp(y(117)),params(230),1)));
  g1(44,31)=(-(exp(y(117))*params(235)*exp(y(31))));
  g1(44,117)=(-(exp(y(117))*params(235)*exp(y(31))));
  g1(44,130)=1;
  g1(45,117)=(-((-(exp(y(117))*y(130)))/(exp(y(117))*exp(y(117)))));
  g1(45,130)=(-(1/exp(y(117))));
  g1(45,131)=1;
  g1(46,132)=1;
  g1(47,31)=(-(exp(y(31))*exp(y(114))*params(235)));
  g1(47,114)=(-(exp(y(31))*exp(y(114))*params(235)));
  g1(47,134)=1;
  g1(48,114)=(-((-(exp(y(114))*y(134)))/(exp(y(114))*exp(y(114)))));
  g1(48,134)=(-(1/exp(y(114))));
  g1(48,135)=1;
  g1(49,136)=1;
  g1(50,34)=(-(params(235)*exp(y(121))*exp(y(34))));
  g1(50,121)=(-(params(235)*exp(y(121))*exp(y(34))));
  g1(50,138)=1;
  g1(51,121)=(-((-(y(138)*exp(y(121))))/(exp(y(121))*exp(y(121)))));
  g1(51,138)=(-(1/exp(y(121))));
  g1(51,139)=1;
  g1(52,140)=1;
  g1(53,116)=exp(y(116))-exp(y(116))*(1-params(7));
  g1(53,130)=(-1);
  g1(54,115)=exp(y(115))-exp(y(115))*(1-params(7));
  g1(54,134)=(-1);
  g1(55,35)=(-(exp(y(124))+(1-params(7))*exp(y(133))));
  g1(55,124)=(-(T117*exp(y(124))));
  g1(55,133)=exp(y(133))-T117*(1-params(7))*exp(y(133));
  g1(56,35)=(-(y(132)*exp(y(133))));
  g1(56,131)=(-exp(y(133)));
  g1(56,132)=(-(y(35)*exp(y(133))));
  g1(56,133)=(-(y(131)*exp(y(133))+y(35)*y(132)*exp(y(133))));
  g1(57,35)=(-(exp(y(125))+(1-params(7))*exp(y(137))));
  g1(57,125)=(-(exp(y(125))*T658));
  g1(57,137)=exp(y(137))-T658*(1-params(7))*exp(y(137));
  g1(58,35)=(-(y(136)*exp(y(137))));
  g1(58,135)=(-exp(y(137)));
  g1(58,136)=(-(y(35)*exp(y(137))));
  g1(58,137)=(-(y(135)*exp(y(137))+y(35)*y(136)*exp(y(137))));
  g1(59,2)=(-(T679*T676*params(231)*exp(y(28))*T411*T439*T671*T1278*T1302));
  g1(59,4)=(-(T679*T676*params(231)*exp(y(28))*T411*T439*T671*T1302*T1369));
  g1(59,28)=(-(T544*params(231)*exp(y(28))*T411*T439*T671*T676*T679));
  g1(59,115)=(-(T679*T544*params(231)*exp(y(28))*T411*T439*T671*T2234*T2239));
  g1(59,116)=(-(T679*T544*params(231)*exp(y(28))*T411*T439*T671*T2239*T2253+T544*params(231)*exp(y(28))*T411*T439*T671*T676*exp(y(116))*getPowerDeriv(exp(y(116)),params(230)-1,1)));
  g1(59,118)=(-(T679*T676*T544*params(231)*exp(y(28))*T411*T439*T2280*T2285));
  g1(59,123)=(-(T679*T676*T544*params(231)*exp(y(28))*T411*T439*T2285*T2365));
  g1(59,124)=exp(y(124));
  g1(60,2)=(-(T686*T676*T671*(1-params(231))*exp(y(28))*T411*T439*T1278*T1302));
  g1(60,4)=(-(T686*T676*T671*(1-params(231))*exp(y(28))*T411*T439*T1302*T1369));
  g1(60,28)=(-(T676*T544*T671*(1-params(231))*exp(y(28))*T411*T439*T686));
  g1(60,115)=(-(T686*T544*T671*(1-params(231))*exp(y(28))*T411*T439*T2234*T2239+T676*T544*T671*(1-params(231))*exp(y(28))*T411*T439*exp(y(115))*getPowerDeriv(exp(y(115)),params(230)-1,1)));
  g1(60,116)=(-(T686*T544*T671*(1-params(231))*exp(y(28))*T411*T439*T2239*T2253));
  g1(60,118)=(-(T686*T676*T544*(1-params(231))*exp(y(28))*T411*T439*T2280*T2285));
  g1(60,123)=(-(T686*T676*T544*(1-params(231))*exp(y(28))*T411*T439*T2285*T2365));
  g1(60,125)=exp(y(125));
  g1(61,31)=1-params(16);
  g1(62,34)=1-params(234);
  g1(63,8)=(-(T117*(-(exp(y(8))*(1+params(22))))));
  g1(63,35)=(-T712);
  g1(63,48)=(-(params(105)*exp(y(48))))/(exp(y(48))*exp(y(48)))-T117*(1-params(101))*(-(params(105)*exp(y(48))))/(exp(y(48))*exp(y(48)));
  g1(63,52)=(-(T117*exp(y(52))));
  g1(64,9)=(-(T117*(-(exp(y(9))*(1+params(22))))));
  g1(64,35)=(-T722);
  g1(64,64)=(-(params(106)*exp(y(64))))/(exp(y(64))*exp(y(64)))-T117*(1-params(102))*(-(params(106)*exp(y(64))))/(exp(y(64))*exp(y(64)));
  g1(64,68)=(-(T117*exp(y(68))));
  g1(65,35)=(-T732);
  g1(65,80)=(-(params(113)*exp(y(80))))/(exp(y(80))*exp(y(80)))-T117*(1-params(111))*(-(params(113)*exp(y(80))))/(exp(y(80))*exp(y(80)));
  g1(65,84)=(-(T117*exp(y(84))));
  g1(65,86)=(-(T117*(-(exp(y(86))*(1+params(22))))));
  g1(66,35)=(-T742);
  g1(66,101)=(-(params(121)*exp(y(101))))/(exp(y(101))*exp(y(101)))-T117*(1-params(119))*(-(params(121)*exp(y(101))))/(exp(y(101))*exp(y(101)));
  g1(66,105)=(-(T117*exp(y(105))));
  g1(66,107)=(-(T117*(-(exp(y(107))*(1+params(22))))));
  g1(67,8)=exp(y(8));
  g1(67,48)=(-((1-params(107))/(1+params(22))*(-(exp(y(48))*(1-params(101))*params(105)))/(exp(y(48))*exp(y(48)))));
  g1(67,50)=(-(T753*T1768));
  g1(67,51)=(-(T753*(-(exp(y(51))*(1-params(101))))));
  g1(67,52)=(-(exp(y(52))*(1-params(107))/(1+params(22))));
  g1(67,53)=(-((T134-exp(y(51))*(1-params(101)))*(-(params(107)*exp(y(53))*(1-params(20))))/(exp(y(53))*(1-params(20))*exp(y(53))*(1-params(20)))));
  g1(68,9)=exp(y(9));
  g1(68,64)=(-((1-params(108))/(1+params(22))*(-(exp(y(64))*(1-params(102))*params(106)))/(exp(y(64))*exp(y(64)))));
  g1(68,66)=(-(T766*T1875));
  g1(68,67)=(-(T766*(-(exp(y(67))*(1-params(102))))));
  g1(68,68)=(-(exp(y(68))*(1-params(108))/(1+params(22))));
  g1(68,69)=(-((T291-exp(y(67))*(1-params(102)))*(-(params(108)*(1-params(20))*exp(y(69))))/((1-params(20))*exp(y(69))*(1-params(20))*exp(y(69)))));
  g1(69,80)=(-((1-params(114))/(1+params(22))*(-(exp(y(80))*(1-params(111))*params(113)))/(exp(y(80))*exp(y(80)))));
  g1(69,82)=(-(T779*T2000));
  g1(69,83)=(-(T779*(-(exp(y(83))*(1-params(111))))));
  g1(69,84)=(-(exp(y(84))*(1-params(114))/(1+params(22))));
  g1(69,85)=(-((T353-exp(y(83))*(1-params(111)))*(-(params(114)*(1-params(20))*exp(y(85))))/((1-params(20))*exp(y(85))*(1-params(20))*exp(y(85)))));
  g1(69,86)=exp(y(86));
  g1(70,101)=(-((1-params(122))/(1+params(22))*(-(exp(y(101))*(1-params(119))*params(121)))/(exp(y(101))*exp(y(101)))));
  g1(70,103)=(-(T792*T2154));
  g1(70,104)=(-(T792*(-(exp(y(104))*(1-params(119))))));
  g1(70,105)=(-(exp(y(105))*(1-params(122))/(1+params(22))));
  g1(70,106)=(-((T199-exp(y(104))*(1-params(119)))*(-(params(122)*(1-params(20))*exp(y(106))))/((1-params(20))*exp(y(106))*(1-params(20))*exp(y(106)))));
  g1(70,107)=exp(y(107));
  g1(71,36)=(-((-(exp(y(36))*exp(y(120))*(1-params(199))))/(exp(y(36))*exp(y(36)))));
  g1(71,120)=exp(y(120))-exp(y(120))*(1-params(199))/exp(y(36));
  g1(71,138)=(-1);
  g1(72,35)=(-(exp(y(119))+(1-params(199))*exp(y(141))));
  g1(72,119)=(-(T117*exp(y(119))));
  g1(72,141)=exp(y(141))-T117*(1-params(199))*exp(y(141));
  g1(73,35)=(-(y(140)*exp(y(141))));
  g1(73,139)=(-exp(y(141)));
  g1(73,140)=(-(y(35)*exp(y(141))));
  g1(73,141)=(-(y(139)*exp(y(141))+y(35)*y(140)*exp(y(141))));
  g1(74,14)=(1-params(221))*exp(y(14))*getPowerDeriv(exp(y(14)),1-params(4),1);
  g1(74,15)=params(221)*exp(y(15))*getPowerDeriv(exp(y(15)),1-params(4),1);
  g1(75,1)=exp(y(1));
  g1(75,5)=(-(exp(y(5))*T826));
  g1(75,14)=(-(exp(y(30))*params(222)*T853*T1530));
  g1(75,15)=(-(T850*params(221)*exp(y(15))*getPowerDeriv(exp(y(15)),(-params(4)),1)+exp(y(30))*params(222)*T1530*(-(exp(y(14))*exp(y(15))))/(exp(y(15))*exp(y(15)))));
  g1(75,16)=(-(T826*exp(y(16))));
  g1(75,17)=(-(exp(y(17))*T826));
  g1(75,24)=(-(T826*exp(y(24))));
  g1(75,30)=(-T859);
  g1(75,46)=(-(T826*params(105)*exp(y(46))));
  g1(75,62)=(-(T826*params(106)*exp(y(62))));
  g1(75,78)=(-(T826*params(113)*exp(y(78))));
  g1(75,99)=(-(T826*params(121)*exp(y(99))));
  g1(75,121)=(-(exp(y(121))*T826));
  g1(76,30)=1-params(6);
  g1(77,12)=(-(params(217)*(-params(10))*exp((-params(10))*(y(12)-params(214)))));
  g1(77,13)=1;
  g1(78,12)=1-T880;
  g1(78,13)=(-y(12));
  g1(78,129)=(-1);
  g1(79,5)=exp(y(5))/exp(y(128));
  g1(79,16)=exp(y(16))/exp(y(128));
  g1(79,17)=exp(y(17))/exp(y(128));
  g1(79,24)=exp(y(24))/exp(y(128));
  g1(79,46)=params(105)*exp(y(46))/exp(y(128));
  g1(79,62)=params(106)*exp(y(62))/exp(y(128));
  g1(79,78)=params(113)*exp(y(78))/exp(y(128));
  g1(79,99)=params(121)*exp(y(99))/exp(y(128));
  g1(79,121)=exp(y(121))/exp(y(128));
  g1(79,128)=(-(T850*exp(y(128))))/(exp(y(128))*exp(y(128)));
  g1(79,129)=1;
  g1(80,1)=(-(exp(y(1))*exp(y(15))));
  g1(80,15)=(-(exp(y(1))*exp(y(15))));
  g1(80,128)=exp(y(128));
  g1(81,7)=(-(exp(y(37))*exp(y(7))));
  g1(81,10)=(-(exp(y(38))*exp(y(10))));
  g1(81,16)=exp(y(16));
  g1(81,37)=(-(exp(y(37))*exp(y(7))));
  g1(81,38)=(-(exp(y(38))*exp(y(10))));
  g1(81,87)=(-(exp(y(90))*exp(y(87))));
  g1(81,90)=(-(exp(y(90))*exp(y(87))));
  g1(81,108)=(-(exp(y(112))*exp(y(108))));
  g1(81,112)=(-(exp(y(112))*exp(y(108))));
  g1(82,12)=1;
  g1(82,37)=(-(exp(y(37))*y(127)));
  g1(82,112)=(-(exp(y(112))*y(126)));
  g1(82,126)=(-exp(y(112)));
  g1(82,127)=(-exp(y(37)));
  g1(83,1)=exp(y(1))*params(50);
  g1(83,17)=exp(y(17))-exp(y(17))*params(1);
  g1(83,18)=params(49);
  g1(83,32)=(-1);
  g1(84,32)=1-params(18);
  g1(85,1)=exp(y(1))*params(53);
  g1(85,18)=params(52);
  g1(85,24)=exp(y(24))-exp(y(24))*params(51);
  g1(85,33)=(-1);
  g1(86,33)=1-params(19);
  g1(87,6)=(-(params(20)*exp(y(44))*exp(y(6))*exp(y(8))));
  g1(87,8)=(-(params(20)*exp(y(44))*exp(y(6))*exp(y(8))));
  g1(87,19)=exp(y(19));
  g1(87,44)=(-(params(20)*exp(y(44))*exp(y(6))*exp(y(8))));
  g1(88,97)=(-(params(20)*exp(y(97))*exp(y(109))*exp(y(107))));
  g1(88,107)=(-(params(20)*exp(y(97))*exp(y(109))*exp(y(107))));
  g1(88,109)=(-(params(20)*exp(y(97))*exp(y(109))*exp(y(107))));
  g1(88,111)=exp(y(111));
  g1(89,76)=(-(params(20)*exp(y(76))*exp(y(88))*exp(y(86))));
  g1(89,86)=(-(params(20)*exp(y(76))*exp(y(88))*exp(y(86))));
  g1(89,88)=(-(params(20)*exp(y(76))*exp(y(88))*exp(y(86))));
  g1(89,89)=exp(y(89));
  g1(90,9)=(-(params(20)*exp(y(60))*exp(y(11))*exp(y(9))));
  g1(90,11)=(-(params(20)*exp(y(60))*exp(y(11))*exp(y(9))));
  g1(90,20)=exp(y(20));
  g1(90,60)=(-(params(20)*exp(y(60))*exp(y(11))*exp(y(9))));
  g1(91,19)=(-(exp(y(37))*exp(y(19))));
  g1(91,20)=(-(exp(y(38))*exp(y(20))));
  g1(91,21)=exp(y(21));
  g1(91,37)=(-(exp(y(37))*exp(y(19))));
  g1(91,38)=(-(exp(y(38))*exp(y(20))));
  g1(91,89)=(-(exp(y(90))*exp(y(89))));
  g1(91,90)=(-(exp(y(90))*exp(y(89))));
  g1(91,111)=(-(exp(y(112))*exp(y(111))));
  g1(91,112)=(-(exp(y(112))*exp(y(111))));
  g1(92,16)=(-(params(21)*exp(y(16))));
  g1(92,22)=exp(y(22));
  g1(93,6)=(-(params(22)*exp(y(42))*exp(y(6))*exp(y(8))));
  g1(93,8)=(-(params(22)*exp(y(42))*exp(y(6))*exp(y(8))));
  g1(93,9)=(-(params(22)*exp(y(58))*exp(y(11))*exp(y(9))));
  g1(93,11)=(-(params(22)*exp(y(58))*exp(y(11))*exp(y(9))));
  g1(93,23)=exp(y(23));
  g1(93,42)=(-(params(22)*exp(y(42))*exp(y(6))*exp(y(8))));
  g1(93,58)=(-(params(22)*exp(y(58))*exp(y(11))*exp(y(9))));
  g1(93,74)=(-(params(22)*exp(y(74))*exp(y(88))*exp(y(86))));
  g1(93,86)=(-(params(22)*exp(y(74))*exp(y(88))*exp(y(86))));
  g1(93,88)=(-(params(22)*exp(y(74))*exp(y(88))*exp(y(86))));
  g1(93,95)=(-(params(22)*exp(y(109))*exp(y(107))*exp(y(95))));
  g1(93,107)=(-(params(22)*exp(y(109))*exp(y(107))*exp(y(95))));
  g1(93,109)=(-(params(22)*exp(y(109))*exp(y(107))*exp(y(95))));
  g1(94,21)=(-exp(y(21)));
  g1(94,22)=(-exp(y(22)));
  g1(94,23)=(-exp(y(23)));
  g1(94,25)=exp(y(25));
  g1(95,13)=(-(y(18)/exp(y(36))));
  g1(95,18)=(-((1+y(13))/exp(y(36))-1));
  g1(95,27)=1;
  g1(95,36)=(-((-(exp(y(36))*(1+y(13))*y(18)))/(exp(y(36))*exp(y(36)))));
  g1(96,17)=(-exp(y(17)));
  g1(96,24)=(-exp(y(24)));
  g1(96,26)=exp(y(26));
  g1(97,25)=(-exp(y(25)));
  g1(97,26)=exp(y(26));
  g1(97,27)=1;
  g1(97,41)=params(76)*exp(y(41));
  g1(97,57)=params(91)*exp(y(57));
  g1(97,73)=params(140)*exp(y(73));
  g1(97,94)=params(125)*exp(y(94));
  g1(98,37)=(-((-(exp(y(37))*(exp(y(42))+exp(y(41)))))/(exp(y(37))*exp(y(37)))));
  g1(98,39)=exp(y(39));
  g1(98,41)=(-(exp(y(41))/exp(y(37))));
  g1(98,42)=(-(exp(y(42))/exp(y(37))));
  g1(99,71)=exp(y(71));
  g1(99,73)=(-(exp(y(73))/exp(y(90))));
  g1(99,74)=(-(exp(y(74))/exp(y(90))));
  g1(99,90)=(-((-(exp(y(90))*(exp(y(74))+exp(y(73)))))/(exp(y(90))*exp(y(90)))));
  g1(100,92)=exp(y(92));
  g1(100,94)=(-(exp(y(94))/exp(y(112))));
  g1(100,95)=(-(exp(y(95))/exp(y(112))));
  g1(100,112)=(-((-(exp(y(112))*(exp(y(95))+exp(y(94)))))/(exp(y(112))*exp(y(112)))));
  g1(101,38)=(-((-(exp(y(38))*(exp(y(58))+exp(y(57)))))/(exp(y(38))*exp(y(38)))));
  g1(101,55)=exp(y(55));
  g1(101,57)=(-(exp(y(57))/exp(y(38))));
  g1(101,58)=(-(exp(y(58))/exp(y(38))));
  g1(102,40)=exp(y(40));
  g1(102,41)=(-((exp(y(41))*(exp(y(42))+exp(y(41)))-exp(y(41))*exp(y(41)))/((exp(y(42))+exp(y(41)))*(exp(y(42))+exp(y(41))))));
  g1(102,42)=(-((-(exp(y(42))*exp(y(41))))/((exp(y(42))+exp(y(41)))*(exp(y(42))+exp(y(41))))));
  g1(103,72)=exp(y(72));
  g1(103,73)=(-((exp(y(73))*(exp(y(74))+exp(y(73)))-exp(y(73))*exp(y(73)))/((exp(y(74))+exp(y(73)))*(exp(y(74))+exp(y(73))))));
  g1(103,74)=(-((-(exp(y(74))*exp(y(73))))/((exp(y(74))+exp(y(73)))*(exp(y(74))+exp(y(73))))));
  g1(104,93)=exp(y(93));
  g1(104,94)=(-((exp(y(94))*(exp(y(95))+exp(y(94)))-exp(y(94))*exp(y(94)))/((exp(y(95))+exp(y(94)))*(exp(y(95))+exp(y(94))))));
  g1(104,95)=(-((-(exp(y(95))*exp(y(94))))/((exp(y(95))+exp(y(94)))*(exp(y(95))+exp(y(94))))));
  g1(105,56)=exp(y(56));
  g1(105,57)=(-((exp(y(57))*(exp(y(58))+exp(y(57)))-exp(y(57))*exp(y(57)))/((exp(y(58))+exp(y(57)))*(exp(y(58))+exp(y(57))))));
  g1(105,58)=(-((-(exp(y(58))*exp(y(57))))/((exp(y(58))+exp(y(57)))*(exp(y(58))+exp(y(57))))));
  g1(106,36)=(-((1-exp(y(40)))*params(74)*exp(y(39))));
  g1(106,39)=(-(exp(y(39))*y(36)*params(74)*(1-exp(y(40)))));
  g1(106,40)=(-(exp(y(39))*y(36)*params(74)*(-exp(y(40)))));
  g1(106,42)=exp(y(42))-(1-params(101))*exp(y(42));
  g1(106,45)=(-exp(y(45)));
  g1(107,36)=(-((1-exp(y(72)))*params(138)*exp(y(71))));
  g1(107,71)=(-(exp(y(71))*y(36)*params(138)*(1-exp(y(72)))));
  g1(107,72)=(-(exp(y(71))*y(36)*params(138)*(-exp(y(72)))));
  g1(107,74)=exp(y(74))-(1-params(111))*exp(y(74));
  g1(107,77)=(-exp(y(77)));
  g1(108,36)=(-((1-exp(y(56)))*params(89)*exp(y(55))));
  g1(108,55)=(-(exp(y(55))*y(36)*params(89)*(1-exp(y(56)))));
  g1(108,56)=(-(exp(y(55))*y(36)*params(89)*(-exp(y(56)))));
  g1(108,58)=exp(y(58))-(1-params(102))*exp(y(58));
  g1(108,61)=(-exp(y(61)));
  g1(109,36)=(-((1-exp(y(93)))*params(185)*exp(y(92))));
  g1(109,92)=(-(exp(y(92))*y(36)*params(185)*(1-exp(y(93)))));
  g1(109,93)=(-(exp(y(92))*y(36)*params(185)*(-exp(y(93)))));
  g1(109,95)=exp(y(95))-(1-params(119))*exp(y(95));
  g1(109,98)=(-exp(y(98)));
  g1(110,37)=(-(exp(y(37))*exp(y(44))));
  g1(110,42)=exp(y(42));
  g1(110,44)=(-(exp(y(37))*exp(y(44))));
  g1(111,74)=exp(y(74));
  g1(111,76)=(-(exp(y(90))*exp(y(76))));
  g1(111,90)=(-(exp(y(90))*exp(y(76))));
  g1(112,38)=(-(exp(y(38))*exp(y(60))));
  g1(112,58)=exp(y(58));
  g1(112,60)=(-(exp(y(38))*exp(y(60))));
  g1(113,95)=exp(y(95));
  g1(113,97)=(-(exp(y(112))*exp(y(97))));
  g1(113,112)=(-(exp(y(112))*exp(y(97))));
  g1(114,36)=(-(exp(y(40))*params(74)*exp(y(39))));
  g1(114,37)=(-(exp(y(37))*exp(y(43))));
  g1(114,39)=(-(y(36)*exp(y(40))*params(74)*exp(y(39))));
  g1(114,40)=(-(y(36)*exp(y(40))*params(74)*exp(y(39))));
  g1(114,41)=exp(y(41));
  g1(114,43)=(-(exp(y(37))*exp(y(43))));
  g1(115,36)=(-(exp(y(72))*params(138)*exp(y(71))));
  g1(115,71)=(-(y(36)*exp(y(72))*params(138)*exp(y(71))));
  g1(115,72)=(-(y(36)*exp(y(72))*params(138)*exp(y(71))));
  g1(115,73)=exp(y(73));
  g1(115,75)=(-(exp(y(90))*exp(y(75))));
  g1(115,90)=(-(exp(y(90))*exp(y(75))));
  g1(116,36)=(-(exp(y(93))*params(185)*exp(y(92))));
  g1(116,92)=(-(y(36)*exp(y(93))*params(185)*exp(y(92))));
  g1(116,93)=(-(y(36)*exp(y(93))*params(185)*exp(y(92))));
  g1(116,94)=exp(y(94));
  g1(116,96)=(-(exp(y(112))*exp(y(96))));
  g1(116,112)=(-(exp(y(112))*exp(y(96))));
  g1(117,36)=(-(exp(y(56))*params(89)*exp(y(55))));
  g1(117,38)=(-(exp(y(38))*exp(y(59))));
  g1(117,55)=(-(y(36)*exp(y(56))*params(89)*exp(y(55))));
  g1(117,56)=(-(y(36)*exp(y(56))*params(89)*exp(y(55))));
  g1(117,57)=exp(y(57));
  g1(117,59)=(-(exp(y(38))*exp(y(59))));
  g1(118,41)=(-(T1145*exp(y(41))*getPowerDeriv(exp(y(41)),1-params(103),1)));
  g1(118,45)=exp(y(45));
  g1(118,46)=(-(T1147*params(99)*exp(y(46))*getPowerDeriv(exp(y(46)),params(103),1)));
  g1(119,73)=(-(T1152*exp(y(73))*getPowerDeriv(exp(y(73)),1-params(103),1)));
  g1(119,77)=exp(y(77));
  g1(119,78)=(-(T1153*params(110)*exp(y(78))*getPowerDeriv(exp(y(78)),params(103),1)));
  g1(120,57)=(-(T1158*exp(y(57))*getPowerDeriv(exp(y(57)),1-params(103),1)));
  g1(120,61)=exp(y(61));
  g1(120,62)=(-(T1159*params(100)*exp(y(62))*getPowerDeriv(exp(y(62)),params(103),1)));
  g1(121,94)=(-(T1164*exp(y(94))*getPowerDeriv(exp(y(94)),1-params(103),1)));
  g1(121,98)=exp(y(98));
  g1(121,99)=(-(T1165*params(118)*exp(y(99))*getPowerDeriv(exp(y(99)),params(103),1)));
  g1(122,41)=(-((-(exp(y(41))*exp(y(45))))/(exp(y(41))*exp(y(41)))));
  g1(122,45)=(-(exp(y(45))/exp(y(41))));
  g1(122,47)=exp(y(47));
  g1(123,57)=(-((-(exp(y(57))*exp(y(61))))/(exp(y(57))*exp(y(57)))));
  g1(123,61)=(-(exp(y(61))/exp(y(57))));
  g1(123,63)=exp(y(63));
  g1(124,73)=(-((-(exp(y(73))*exp(y(77))))/(exp(y(73))*exp(y(73)))));
  g1(124,77)=(-(exp(y(77))/exp(y(73))));
  g1(124,79)=exp(y(79));
  g1(125,94)=(-((-(exp(y(94))*exp(y(98))))/(exp(y(94))*exp(y(94)))));
  g1(125,98)=(-(exp(y(98))/exp(y(94))));
  g1(125,100)=exp(y(100));
  g1(126,45)=(-(exp(y(45))/exp(y(46))));
  g1(126,46)=(-((-(exp(y(46))*exp(y(45))))/(exp(y(46))*exp(y(46)))));
  g1(126,48)=exp(y(48));
  g1(127,61)=(-(exp(y(61))/exp(y(62))));
  g1(127,62)=(-((-(exp(y(62))*exp(y(61))))/(exp(y(62))*exp(y(62)))));
  g1(127,64)=exp(y(64));
  g1(128,77)=(-(exp(y(77))/exp(y(78))));
  g1(128,78)=(-((-(exp(y(78))*exp(y(77))))/(exp(y(78))*exp(y(78)))));
  g1(128,80)=exp(y(80));
  g1(129,98)=(-(exp(y(98))/exp(y(99))));
  g1(129,99)=(-((-(exp(y(99))*exp(y(98))))/(exp(y(99))*exp(y(99)))));
  g1(129,101)=exp(y(101));
  g1(130,41)=(-((-(exp(y(46))*exp(y(41))))/(exp(y(41))*exp(y(41)))));
  g1(130,46)=(-(exp(y(46))/exp(y(41))));
  g1(130,49)=exp(y(49));
  g1(131,57)=(-((-(exp(y(62))*exp(y(57))))/(exp(y(57))*exp(y(57)))));
  g1(131,62)=(-(exp(y(62))/exp(y(57))));
  g1(131,65)=exp(y(65));
  g1(132,73)=(-((-(exp(y(78))*exp(y(73))))/(exp(y(73))*exp(y(73)))));
  g1(132,78)=(-(exp(y(78))/exp(y(73))));
  g1(132,81)=exp(y(81));
  g1(133,94)=(-((-(exp(y(99))*exp(y(94))))/(exp(y(94))*exp(y(94)))));
  g1(133,99)=(-(exp(y(99))/exp(y(94))));
  g1(133,102)=exp(y(102));
  g1(134,43)=(-exp(y(43)));
  g1(134,44)=(-exp(y(44)));
  g1(134,50)=(-exp(y(50)));
  g1(135,59)=(-exp(y(59)));
  g1(135,60)=(-exp(y(60)));
  g1(135,66)=(-exp(y(66)));
  g1(136,75)=(-exp(y(75)));
  g1(136,76)=(-exp(y(76)));
  g1(136,82)=(-exp(y(82)));
  g1(137,96)=(-exp(y(96)));
  g1(137,97)=(-exp(y(97)));
  g1(137,103)=(-exp(y(103)));
  g1(138,6)=(-(exp(y(6))*exp(y(42))));
  g1(138,42)=(-(exp(y(6))*exp(y(42))));
  g1(138,54)=exp(y(54));
  g1(139,11)=(-(exp(y(11))*exp(y(58))));
  g1(139,58)=(-(exp(y(11))*exp(y(58))));
  g1(139,70)=exp(y(70));
  g1(140,74)=(-(exp(y(88))*exp(y(74))));
  g1(140,88)=(-(exp(y(88))*exp(y(74))));
  g1(140,91)=exp(y(91));
  g1(141,95)=(-(exp(y(109))*exp(y(95))));
  g1(141,109)=(-(exp(y(109))*exp(y(95))));
  g1(141,113)=exp(y(113));
  g1(142,8)=(-(exp(y(8))/exp(y(86))));
  g1(142,86)=(-((-(exp(y(8))*exp(y(86))))/(exp(y(86))*exp(y(86)))));
  g1(142,142)=exp(y(142));
  g1(143,8)=(-(exp(y(8))/exp(y(107))));
  g1(143,107)=(-((-(exp(y(8))*exp(y(107))))/(exp(y(107))*exp(y(107)))));
  g1(143,143)=exp(y(143));
  g1(144,9)=(-((-(exp(y(9))*exp(y(86))))/(exp(y(9))*exp(y(9)))));
  g1(144,86)=(-(exp(y(86))/exp(y(9))));
  g1(144,144)=exp(y(144));
  g1(145,9)=(-((-(exp(y(107))*exp(y(9))))/(exp(y(9))*exp(y(9)))));
  g1(145,107)=(-(exp(y(107))/exp(y(9))));
  g1(145,145)=exp(y(145));
  g1(146,42)=(-((exp(y(42))*T1244-exp(y(42))*exp(y(42)))/(T1244*T1244)));
  g1(146,58)=(-((-(exp(y(58))*exp(y(42))))/(T1244*T1244)));
  g1(146,74)=(-((-(exp(y(74))*exp(y(42))))/(T1244*T1244)));
  g1(146,95)=(-((-(exp(y(42))*exp(y(95))))/(T1244*T1244)));
  g1(146,146)=exp(y(146));
  g1(147,42)=(-((-(exp(y(74))*exp(y(42))))/(T1244*T1244)));
  g1(147,58)=(-((-(exp(y(74))*exp(y(58))))/(T1244*T1244)));
  g1(147,74)=(-((exp(y(74))*T1244-exp(y(74))*exp(y(74)))/(T1244*T1244)));
  g1(147,95)=(-((-(exp(y(74))*exp(y(95))))/(T1244*T1244)));
  g1(147,147)=exp(y(147));
  g1(148,42)=(-((-(exp(y(58))*exp(y(42))))/(T1244*T1244)));
  g1(148,58)=(-((exp(y(58))*T1244-exp(y(58))*exp(y(58)))/(T1244*T1244)));
  g1(148,74)=(-((-(exp(y(74))*exp(y(58))))/(T1244*T1244)));
  g1(148,95)=(-((-(exp(y(58))*exp(y(95))))/(T1244*T1244)));
  g1(148,148)=exp(y(148));
  g1(149,42)=(-((-(exp(y(42))*exp(y(95))))/(T1244*T1244)));
  g1(149,58)=(-((-(exp(y(58))*exp(y(95))))/(T1244*T1244)));
  g1(149,74)=(-((-(exp(y(74))*exp(y(95))))/(T1244*T1244)));
  g1(149,95)=(-((exp(y(95))*T1244-exp(y(95))*exp(y(95)))/(T1244*T1244)));
  g1(149,149)=exp(y(149));
  g1(150,6)=(-(exp(y(44))*exp(y(6))*exp(y(8))));
  g1(150,8)=(-(exp(y(44))*exp(y(6))*exp(y(8))));
  g1(150,44)=(-(exp(y(44))*exp(y(6))*exp(y(8))));
  g1(150,150)=exp(y(150));
  g1(151,76)=(-(exp(y(76))*exp(y(88))*exp(y(86))));
  g1(151,86)=(-(exp(y(76))*exp(y(88))*exp(y(86))));
  g1(151,88)=(-(exp(y(76))*exp(y(88))*exp(y(86))));
  g1(151,151)=exp(y(151));
  g1(152,9)=(-(exp(y(60))*exp(y(11))*exp(y(9))));
  g1(152,11)=(-(exp(y(60))*exp(y(11))*exp(y(9))));
  g1(152,60)=(-(exp(y(60))*exp(y(11))*exp(y(9))));
  g1(152,152)=exp(y(152));
  g1(153,97)=(-(exp(y(97))*exp(y(109))*exp(y(107))));
  g1(153,107)=(-(exp(y(97))*exp(y(109))*exp(y(107))));
  g1(153,109)=(-(exp(y(97))*exp(y(109))*exp(y(107))));
  g1(153,153)=exp(y(153));
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],153,23409);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],153,3581577);
end
end
end
end
